/*
 *  Star.cpp
 *  emptyExample
 *
 *  Created by Josh Nimoy on 12/22/10.
 *  Copyright 2010 Josh Nimoy. All rights reserved.
 *
 */

#include "Star.h"
#include "ofMain.h"

Star::Star():JPoint(){
	ticks = 0;	
	SphereCoord sc(rnd[2]*200+100,rnd[0]*M_PI,rnd[1]*M_PI*2);
	copyFrom(sc.getCartesian());
	radius = 0;
}

void Star::step(){
	radius = cos(ticks*0.1+rnd[4]*10)*10*rnd[5];
	
	ticks++;
	
}

void Star::draw(){
	glPushMatrix();
	
	int steps = (rnd[3] * 4) + 2;
	float inc = (M_PI) / steps;
	
	glBegin(GL_LINES);
	
	for(int i=0;i<steps;i++){
		float x = radius * cos(inc*i);
		float y = radius * sin(inc*i);
		glVertex2f(x,y);
		glVertex2f(-x,-y);
	}
	
	glEnd();
	
	glPopMatrix();	
}

